/* Copyright (C) 2000-2002 Lavtech.com corp. All rights reserved.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <ctype.h>

#include "udm_config.h"
#include "udm_common.h"
#include "udm_log.h"
#include "udm_spell.h"
#include "udm_xmalloc.h"
#include "udm_agent.h"
#include "udm_utils.h"
#include "udm_unicode.h"
#include "udm_mutex.h"
#include "udm_crc32.h"
#include "udm_word.h"


#define WSIZE		1024
#define BSIZE		10

static int AddOneWord(UDM_DOCUMENT *Doc,char *word,int weight){
	/* Realloc memory when required  */
	if(Doc->Words.nwords>=Doc->Words.mwords){
		Doc->Words.mwords+=WSIZE;
		Doc->Words.Word=(UDM_WORD *)UdmXrealloc(Doc->Words.Word,Doc->Words.mwords*sizeof(UDM_WORD));
	}

	/* Add new word */
	Doc->Words.Word[Doc->Words.nwords].word=strdup(word);
	Doc->Words.Word[Doc->Words.nwords].coord=UDM_WRDCOORD(Doc->CrossWords.wordpos,weight);
	Doc->Words.nwords++;

	return(UDM_OK);
}

/* This function adds a normalized word form(s) into list using Ispell */
int UdmWordListAdd(UDM_DOCUMENT * Doc,char *word,int weight){

	Doc->CrossWords.wordpos++;
	return AddOneWord(Doc,word,weight);
}

int UdmWordListFree(UDM_WORDLIST * List){
	size_t i;
	for(i=0;i<List->nwords;i++)
		free(List->Word[i].word);
	List->nwords=0;
	List->swords=0;
	UDM_FREE(List->Word);
	return(0);
}

UDM_WORDLIST * UdmWordListInit(UDM_WORDLIST * List){
	bzero(List,sizeof(*List));
	return(List);
}


UDM_WIDEWORDLIST * UdmWideWordListInit(UDM_WIDEWORDLIST * List){
	bzero(List,sizeof(*List));
	return(List);
}

size_t UdmWideWordListAdd(UDM_WIDEWORDLIST * List,UDM_WIDEWORD * Word, int unique){

  if (unique) {
    size_t i;
    for (i = 0; i < List->nwords; i++) {
      if (List->Word[i].len == Word->len &&
	  (UdmUniStrCmp(List->Word[i].uword, Word->uword) == 0)) {
	return(List->nwords); 
      }
    }
  }

	/* Realloc memory */
	List->Word=(UDM_WIDEWORD*)UdmXrealloc(List->Word,sizeof(*(List->Word))*(List->nwords+1));
	bzero(&List->Word[List->nwords],sizeof(*(List->Word)));
	
	/* Copy data */
	List->Word[List->nwords].len=Word->len;
	List->Word[List->nwords].order=Word->order;
	List->Word[List->nwords].count=Word->count;
	List->Word[List->nwords].crcword=Word->crcword;
	List->Word[List->nwords].word=Word->word?strdup(Word->word):NULL;
	List->Word[List->nwords].uword=Word->uword?UdmUniDup(Word->uword):NULL;
	List->Word[List->nwords].origin = Word->origin;
	List->nwords++;
	return(List->nwords);
}

void UdmWideWordListFree(UDM_WIDEWORDLIST * List){
	size_t i;
	for(i=0;i<List->nwords;i++){
		UDM_FREE(List->Word[i].word);
		UDM_FREE(List->Word[i].uword);
	}
	UDM_FREE(List->Word);
	UdmWideWordListInit(List);
}
